/**
  ******************************************************************************
  * @file    py32md530_hal_msp.c
  * @author  MCU Application Team
  * @brief   This file provides code for the MSP Initialization
  *          and de-Initialization codes.
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2023 Puya Semiconductor Co.
  * All rights reserved.</center></h2>
  *
  * This software component is licensed by Puya under BSD 3-Clause license,
  * the "License"; You may not use this file except in compliance with the
  * License. You may obtain a copy of the License at:
  *                        opensource.org/licenses/BSD-3-Clause
  *
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2016 STMicroelectronics.
  * All rights reserved.</center></h2>
  *
  * This software component is licensed by ST under BSD 3-Clause license,
  * the "License"; You may not use this file except in compliance with the
  * License. You may obtain a copy of the License at:
  *                        opensource.org/licenses/BSD-3-Clause
  *
  ******************************************************************************
  */

/* Includes ------------------------------------------------------------------*/
#include "main.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* External functions --------------------------------------------------------*/

/**
  * @brief Initialize global MSP.
  */
void HAL_MspInit(void)
{
  __HAL_RCC_SYSCFG_CLK_ENABLE();
  __HAL_RCC_PWR_CLK_ENABLE();
}

/**
* @brief LPUART MSP Initialization
* This function configures the hardware resources used in this example
* @param hlpuart: LPUART handle pointer
* @retval None
*/
void HAL_LPUART_MspInit(LPUART_HandleTypeDef* hlpuart)
{
  GPIO_InitTypeDef GPIO_InitStruct = {0};
  if(hlpuart->Instance == LPUART1)
  {
    /* Peripheral clock enable */
    __HAL_RCC_LPUART1_CLK_ENABLE();
    /* DMA controller clock enable */
    __HAL_RCC_DMA1_CLK_ENABLE();
    __HAL_RCC_GPIOA_CLK_ENABLE();
    
    /**LPUART1 GPIO Configuration
    PA2     ------> LPUART1_RX
    PA4     ------> LPUART1_TX
    */
    GPIO_InitStruct.Pin       = GPIO_PIN_2 | GPIO_PIN_4;
    GPIO_InitStruct.Mode      = GPIO_MODE_AF_PP;
    GPIO_InitStruct.Pull      = GPIO_PULLUP;
    GPIO_InitStruct.Speed     = GPIO_SPEED_FREQ_HIGH;
    GPIO_InitStruct.Alternate = GPIO_AF6_LPUART1;
    HAL_GPIO_Init(GPIOA, &GPIO_InitStruct);

    /* LPUART1 DMA Init */
    /* LPUART1_RX Init */
    hdma_lpuart_rx.Instance                 = DMA1_Channel2;
    hdma_lpuart_rx.Init.Direction           = DMA_PERIPH_TO_MEMORY;
    hdma_lpuart_rx.Init.PeriphInc           = DMA_PADDR_FIX;
    hdma_lpuart_rx.Init.MemInc              = DMA_MADDR_INC;
    hdma_lpuart_rx.Init.PeriphDataAlignment = DMA_PDATAALIGN_BYTE;
    hdma_lpuart_rx.Init.MemDataAlignment    = DMA_MDATAALIGN_BYTE;
    hdma_lpuart_rx.Init.Mode                = DMA_NORMAL;
    hdma_lpuart_rx.Init.Priority            = DMA_PRIORITY_1;
    hdma_lpuart_rx.Init.TransMode           = DMA_TRANSFER_SINGLE;
    /* DMA initialization */
    if (HAL_DMA_Init(&hdma_lpuart_rx) != HAL_OK)
    {
      APP_ErrorHandler();
    }
    HAL_DMA_ChannelMap(&hdma_lpuart_rx, DMA_CHANNEL_MAP_LPUART1_RX);
    __HAL_LINKDMA(hlpuart, hdmarx, hdma_lpuart_rx);

    /* LPUART1_TX Init */
    hdma_lpuart_tx.Instance                 = DMA1_Channel1;
    hdma_lpuart_tx.Init.Direction           = DMA_MEMORY_TO_PERIPH;
    hdma_lpuart_tx.Init.PeriphInc           = DMA_PADDR_FIX;
    hdma_lpuart_tx.Init.MemInc              = DMA_MADDR_INC;
    hdma_lpuart_tx.Init.PeriphDataAlignment = DMA_PDATAALIGN_BYTE;
    hdma_lpuart_tx.Init.MemDataAlignment    = DMA_MDATAALIGN_BYTE;
    hdma_lpuart_tx.Init.Mode                = DMA_NORMAL;
    hdma_lpuart_tx.Init.Priority            = DMA_PRIORITY_0;
    hdma_lpuart_tx.Init.TransMode           = DMA_TRANSFER_SINGLE;
    /* DMA initialization */
    if (HAL_DMA_Init(&hdma_lpuart_tx) != HAL_OK)
    {
      APP_ErrorHandler();
    }
    HAL_DMA_ChannelMap(&hdma_lpuart_tx, DMA_CHANNEL_MAP_LPUART1_TX);
    __HAL_LINKDMA(hlpuart, hdmatx, hdma_lpuart_tx);

    /* NVIC enable */
    HAL_NVIC_SetPriority(DMA1_Channel1_IRQn, 1, 0);
    HAL_NVIC_EnableIRQ(DMA1_Channel1_IRQn);
    HAL_NVIC_SetPriority(DMA1_Channel2_IRQn, 1, 0);
    HAL_NVIC_EnableIRQ(DMA1_Channel2_IRQn);
    
    /* LPUART1 interrupt Init */
    HAL_NVIC_SetPriority(LPUART1_IRQn, 1, 0);
    HAL_NVIC_EnableIRQ(LPUART1_IRQn);
  }
}
/************************ (C) COPYRIGHT Puya *****END OF FILE******************/
